<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}

include ('includes/header.php');

$table_name = 'users';
$res = $db->select($table_name, '*', '', '');

if(isset($_POST['submit'])){
	unset($_POST['submit']);
	$updateData = $_POST;
	$db->update($table_name, $updateData, 'id = :id',[':id' => 1]);
	session_regenerate_id();
	$_SESSION['loggedin'] = true;
	$_SESSION['name'] = $_POST['username'];
	echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Atualizar Credenciais</title>
    <style>
        :root {
            --primary-black: #000000;
            --dark-red: #8B0000;
            --bright-red: #FF0000;
            --dark-gray: #1a1a1a;
            --light-gray: #f8f9fa;
        }
        
        body {
            background: linear-gradient(135deg, var(--primary-black), var(--dark-red));
            background-attachment: fixed;
            color: white;
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }
        
        .page-container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        
        .main-content {
            flex: 1;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            padding-top: 40px;
            padding-bottom: 40px;
        }
        
        .card-custom {
            background: rgba(0, 0, 0, 0.7);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(255, 0, 0, 0.2);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 0, 0, 0.2);
            overflow: visible;
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
        }
        
        .card-header-custom {
            background: linear-gradient(90deg, var(--primary-black), var(--dark-red));
            padding: 20px;
            border-bottom: 2px solid var(--bright-red);
            text-align: center;
        }
        
        .card-body-custom {
            padding: 30px;
        }
        
        .alert-custom {
            background-color: rgba(23, 162, 184, 0.2);
            border: 1px solid rgba(23, 162, 184, 0.3);
            color: #d1ecf1;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 25px;
            text-align: center;
        }
        
        .alert-custom strong {
            color: #ffffff;
            font-weight: 700;
        }
        
        .alert-custom em {
            font-style: italic;
        }
        
        .form-control {
            background-color: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 0, 0, 0.3);
            color: white;
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s;
            height: auto;
            min-height: 45px;
            width: 100%;
            margin-bottom: 20px;
        }
        
        .form-control:focus {
            background-color: rgba(255, 255, 255, 0.15);
            border-color: var(--bright-red);
            box-shadow: 0 0 0 0.2rem rgba(255, 0, 0, 0.25);
            color: white;
        }
        
        .form-label {
            font-weight: 600;
            color: #f8f9fa;
            margin-bottom: 8px;
            display: block;
            font-size: 1.1em;
        }
        
        .btn-custom {
            background: linear-gradient(45deg, var(--primary-black), var(--dark-red));
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: bold;
            color: white;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(255, 0, 0, 0.2);
            margin-top: 15px;
        }
        
        .btn-custom:hover {
            background: linear-gradient(45deg, var(--dark-red), var(--primary-black));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 0, 0, 0.3);
            color: white;
        }
        
        h2, h3 {
            font-weight: 700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
        }
        
        .emoji {
            font-size: 1.2em;
            margin-right: 8px;
        }
        
        .divider {
            height: 1px;
            background: linear-gradient(90deg, transparent, var(--bright-red), transparent);
            margin: 25px 0;
            border: none;
        }
        
        /* Responsividade para dispositivos móveis */
        @media (max-width: 768px) {
            .main-content {
                padding: 15px;
                padding-top: 20px;
                padding-bottom: 20px;
            }
            
            .card-body-custom {
                padding: 20px;
            }
            
            .card-header-custom {
                padding: 15px;
            }
            
            h2 {
                font-size: 1.5rem;
            }
            
            h3 {
                font-size: 1.3rem;
            }
            
            .btn-custom {
                padding: 10px 20px;
                width: 100%;
            }
        }
        
        @media (max-width: 576px) {
            .card-body-custom {
                padding: 15px;
            }
            
            .form-control {
                padding: 10px;
            }
            
            .alert-custom {
                padding: 12px;
                font-size: 0.9em;
            }
        }
    </style>
</head>
<body>
<div class="page-container">
    <div class="main-content">
        <div class="card-custom">
            <div class="card-header-custom">
                <h2><span class="emoji">👤</span> Atualizar Credenciais</h2>
            </div>
            
            <div class="card-body-custom">
                <div class="alert-custom">
                    <h3><span class="emoji">⚠️</span> Não use <strong>admin</strong> para nome de usuário ou senha!</h3>
                </div>

                <form method="post">
                    <div class="form-group">
                        <label class="form-label"><span class="emoji">🔑</span> Nome de Usuário</label>
                        <input type="text" class="form-control" name="username" value="<?=$res[0]['username'] ?>" required>
                    </div>

                    <div class="form-group">
                        <label class="form-label"><span class="emoji">🔒</span> Senha</label>
                        <input type="text" class="form-control" name="password" value="<?=$res[0]['password'] ?>" required>
                    </div>

                    <hr class="divider">

                    <center>
                        <button type="submit" name="submit" class="btn btn-custom">
                            <span class="emoji">💾</span> Atualizar Credenciais
                        </button>
                    </center>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include ('includes/footer.php'); ?>
</body>
</html>