<?php
session_start();

// Verificação de login
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}

include('includes/header.php');

// Caminho do arquivo background
$uploadDir = __DIR__ . '/img/';
$uploadFile = $uploadDir . 'bg.jpg';

// Upload do background
if (isset($_POST['submit'])) {
    if (isset($_FILES['bg']) && $_FILES['bg']['error'] === UPLOAD_ERR_OK) {
        $tmpName = $_FILES['bg']['tmp_name'];

        // Verifica se é uma imagem válida
        $check = getimagesize($tmpName);
        if ($check !== false) {
            // Move a imagem enviada para bg.jpg
            if (move_uploaded_file($tmpName, $uploadFile)) {
                $msg = "<div class='alert alert-success text-center'>✅ Background atualizado com sucesso!</div>";
            } else {
                $msg = "<div class='alert alert-danger text-center'>❌ Erro ao salvar o background.</div>";
            }
        } else {
            $msg = "<div class='alert alert-warning text-center'>⚠️ O arquivo enviado não é uma imagem válida.</div>";
        }
    } else {
        $msg = "<div class='alert alert-danger text-center'>📂 Nenhum arquivo selecionado ou erro no upload.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciamento de Background</title>
    <style>
        :root {
            --primary-black: #000000;
            --dark-red: #8B0000;
            --bright-red: #FF0000;
            --dark-gray: #1a1a1a;
            --light-gray: #f8f9fa;
        }
        
        body {
            background: linear-gradient(135deg, var(--primary-black), var(--dark-red));
            background-attachment: fixed;
            color: white;
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 0;
        }
        
        .page-container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        
        .main-content {
            flex: 1;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            padding-top: 40px;
            padding-bottom: 40px;
        }
        
        .card-custom {
            background: rgba(0, 0, 0, 0.7);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(255, 0, 0, 0.2);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 0, 0, 0.2);
            overflow: visible;
            width: 100%;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .card-header-custom {
            background: linear-gradient(90deg, var(--primary-black), var(--dark-red));
            padding: 20px;
            border-bottom: 2px solid var(--bright-red);
            text-align: center;
        }
        
        .card-body-custom {
            padding: 30px;
            text-align: center;
        }
        
        .form-control {
            background-color: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 0, 0, 0.3);
            color: white;
            border-radius: 8px;
            padding: 12px 15px;
            transition: all 0.3s;
            height: auto;
            min-height: 45px;
            width: 100%;
            margin-bottom: 20px;
        }
        
        .form-control:focus {
            background-color: rgba(255, 255, 255, 0.15);
            border-color: var(--bright-red);
            box-shadow: 0 0 0 0.2rem rgba(255, 0, 0, 0.25);
            color: white;
        }
        
        .form-label {
            font-weight: 600;
            color: #f8f9fa;
            margin-bottom: 8px;
            display: block;
            font-size: 1.1em;
        }
        
        .btn-custom {
            background: linear-gradient(45deg, var(--primary-black), var(--dark-red));
            border: none;
            border-radius: 8px;
            padding: 12px 30px;
            font-weight: bold;
            color: white;
            transition: all 0.3s;
            box-shadow: 0 4px 15px rgba(255, 0, 0, 0.2);
            margin-top: 15px;
            display: inline-block;
            text-decoration: none;
            text-align: center;
        }
        
        .btn-custom:hover {
            background: linear-gradient(45deg, var(--dark-red), var(--primary-black));
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 0, 0, 0.3);
            color: white;
            text-decoration: none;
        }
        
        h2, h3, h4 {
            font-weight: 700;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.5);
        }
        
        .emoji {
            font-size: 1.2em;
            margin-right: 8px;
        }
        
        .current-bg {
            margin-bottom: 30px;
        }
        
        .current-bg img {
            max-height: 250px;
            max-width: 100%;
            background: #fff;
            padding: 10px;
            border-radius: 10px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
            border: 1px solid rgba(255, 0, 0, 0.3);
        }
        
        /* Alertas estilizados */
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid transparent;
        }
        
        .alert-success {
            background-color: rgba(40, 167, 69, 0.2);
            border-color: rgba(40, 167, 69, 0.3);
            color: #d4edda;
        }
        
        .alert-danger {
            background-color: rgba(220, 53, 69, 0.2);
            border-color: rgba(220, 53, 69, 0.3);
            color: #f8d7da;
        }
        
        .alert-warning {
            background-color: rgba(255, 193, 7, 0.2);
            border-color: rgba(255, 193, 7, 0.3);
            color: #fff3cd;
        }
        
        /* Responsividade para dispositivos móveis */
        @media (max-width: 768px) {
            .main-content {
                padding: 15px;
                padding-top: 20px;
                padding-bottom: 20px;
            }
            
            .card-body-custom {
                padding: 20px;
            }
            
            .card-header-custom {
                padding: 15px;
            }
            
            h2 {
                font-size: 1.5rem;
            }
            
            h3, h4 {
                font-size: 1.3rem;
            }
            
            .btn-custom {
                padding: 10px 20px;
                width: 100%;
            }
            
            .current-bg img {
                max-height: 200px;
            }
        }
        
        @media (max-width: 576px) {
            .card-body-custom {
                padding: 15px;
            }
            
            .form-control {
                padding: 10px;
            }
            
            .current-bg img {
                max-height: 180px;
            }
        }
    </style>
</head>
<body>
<div class="page-container">
    <div class="main-content">
        <div class="card-custom">
            <div class="card-header-custom">
                <h2><span class="emoji">🌄</span> Gerenciar Background</h2>
                <p><span class="emoji">📌</span> Envie uma nova imagem para substituir o fundo atual</p>
            </div>
            
            <div class="card-body-custom">
                <?php if (isset($msg)) echo $msg; ?>
                
                <div class="current-bg">
                    <h4><span class="emoji">🔎</span> Background Atual</h4>
                    <img src="img/bg.jpg?<?=time()?>" 
                         alt="Background atual">
                </div>
                
                <form method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="bg" class="form-label">
                            <span class="emoji">📤</span> Selecione uma nova imagem:
                        </label>
                        <input type="file" class="form-control" name="bg" id="bg" accept="image/*" required>
                    </div>
                    <button class="btn btn-custom" name="submit" type="submit">
                        <span class="emoji">🚀</span> Enviar / Substituir Background
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>
</body>
</html>